<?php $u=auth_user(); ?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Alphahall — Canal de Denúncias</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link rel="icon" type="image/png" href="/assets/logo.png">
</head>
<body>
<nav class="navbar navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand d-flex align-items-center gap-2" href="/">
      <img src="/assets/logo.png" alt="Alphahall Cosméticos" height="24">
      <span>Alphahall — Canal de Denúncias</span>
    </a>
    <div class="d-flex align-items-center gap-3">
      <?php if($u): ?>
        <?php if($u['perfil']==='administrador'): ?>
          <a class="btn btn-outline-light btn-sm" href="/usuarios">Usuários</a>
        <?php endif; ?>
        <a class="btn btn-outline-light btn-sm" href="/denuncia/nova">Nova denúncia</a>
        <a class="btn btn-outline-light btn-sm" href="/denuncias">Minhas/Todas</a>
        <span class="text-white-50 small">Olá, <?=safe_str($u['nome'])?> (<?=safe_str($u['perfil'])?>)</span>
        <a class="btn btn-warning btn-sm" href="/logout">Sair</a>
      <?php else: ?>
        <a class="btn btn-outline-light btn-sm" href="/publico/denuncia">Denunciar anonimamente</a>
        <a class="btn btn-outline-light btn-sm" href="/publico/consulta">Consultar código</a>
        <a class="btn btn-success btn-sm" href="/login">Entrar</a>
      <?php endif; ?>
    </div>
  </div>
</nav>
<div class="container">
  <?php if(!empty($_SESSION['flash_success'])){ echo '<div class="alert alert-success">'.safe_str($_SESSION['flash_success']).'</div>'; unset($_SESSION['flash_success']); } ?>
  <?php if(!empty($_SESSION['flash'])){ echo '<div class="alert alert-danger">'.safe_str($_SESSION['flash']).'</div>'; unset($_SESSION['flash']); } ?>
  <?php include __DIR__."/".$_view; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
</body></html>
