<?php
// app/config/conexao_db.php — robusto ao .env ausente e com fallback para getenv()

$envPath = __DIR__ . '/../../.env';
$env = [];
if (is_readable($envPath)) {
  $parsed = parse_ini_file($envPath);
  if (is_array($parsed)) { $env = $parsed; }
}

// Fallback para variáveis de ambiente reais (caso usem cPanel/Apache SetEnv)
$fetch = function($k, $def=null) use ($env) {
  if (array_key_exists($k, $env)) return $env[$k];
  $v = getenv($k);
  return $v !== false ? $v : $def;
};

date_default_timezone_set($fetch('TZ', 'America/Bahia'));

$host = $fetch('DB_HOST', 'localhost');
$db   = $fetch('DB_NAME', '');
$user = $fetch('DB_USER', '');
$pass = $fetch('DB_PASS', '');

$dsn = sprintf('mysql:host=%s;dbname=%s;charset=utf8mb4', $host, $db);
$options = [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
];

try {
  $pdo = new PDO($dsn, $user, $pass, $options);
  $pdo->exec("SET time_zone = '-03:00'");
} catch (PDOException $e) {
  http_response_code(500);
  die('Erro de conexão: ' . $e->getMessage());
}
