<?php
// app/models/Categoria.php — proteção contra redefinição + API do model
if (!class_exists('Categoria')) {
  class Categoria {
    public static function all(PDO $pdo){ return $pdo->query('SELECT * FROM categorias ORDER BY nome')->fetchAll(); }
    public static function active(PDO $pdo){ return $pdo->query('SELECT id,nome FROM categorias WHERE ativo=1 ORDER BY nome')->fetchAll(); }
    public static function find(PDO $pdo,$id){ $s=$pdo->prepare('SELECT * FROM categorias WHERE id=:id'); $s->execute([':id'=>$id]); return $s->fetch(); }
    public static function create(PDO $pdo,$nome,$ativo){ $s=$pdo->prepare('INSERT INTO categorias(nome,ativo) VALUES (:n,:a)'); $s->execute([':n'=>$nome,':a'=>$ativo?1:0]); }
    public static function update(PDO $pdo,$id,$nome,$ativo){ $s=$pdo->prepare('UPDATE categorias SET nome=:n, ativo=:a WHERE id=:id'); $s->execute([':n'=>$nome,':a'=>$ativo?1:0,':id'=>$id]); }
    public static function delete(PDO $pdo,$id){ $s=$pdo->prepare('DELETE FROM categorias WHERE id=:id'); $s->execute([':id'=>$id]); }
  }
}
