SET NAMES utf8mb4;
SET time_zone = '-03:00';

CREATE TABLE IF NOT EXISTS usuarios (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(120) NOT NULL,
  email VARCHAR(160) NOT NULL UNIQUE,
  cpf CHAR(11) NOT NULL UNIQUE,
  telefone VARCHAR(20) NULL,
  senha_hash VARCHAR(255) NOT NULL,
  perfil ENUM('administrador','gerente','colaborador') NOT NULL DEFAULT 'colaborador',
  ativo TINYINT(1) NOT NULL DEFAULT 1,
  criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
  atualizado_em DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS categorias (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(120) NOT NULL UNIQUE,
  ativo TINYINT(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT IGNORE INTO categorias (id, nome, ativo) VALUES
(1,'Assédio Moral',1),
(2,'Assédio Sexual',1),
(3,'Discriminação',1),
(4,'Fraude / Corrupção',1),
(5,'Roubo / Furto',1),
(6,'Conflito de Interesses',1),
(7,'Outros',1);

CREATE TABLE IF NOT EXISTS denuncias (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  protocolo VARCHAR(32) NULL UNIQUE,
  titulo VARCHAR(200) NOT NULL,
  descricao TEXT NOT NULL,
  categoria_id INT NULL,
  localizacao VARCHAR(160) NULL,
  anonima TINYINT(1) NOT NULL DEFAULT 0,
  denunciante_usuario_id INT NULL,
  denunciante_hash VARCHAR(64) NULL,
  status ENUM('nova','em_triagem','em_investigacao','concluida','descartada') NOT NULL DEFAULT 'nova',
  prioridade ENUM('baixa','media','alta','critica') DEFAULT 'media',
  atribuido_a INT NULL,
  prazo DATETIME NULL,
  criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
  atualizado_em DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (denunciante_usuario_id) REFERENCES usuarios(id) ON DELETE SET NULL,
  FOREIGN KEY (atribuido_a) REFERENCES usuarios(id) ON DELETE SET NULL,
  FOREIGN KEY (categoria_id) REFERENCES categorias(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS comentarios (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  denuncia_id BIGINT NOT NULL,
  usuario_id INT NULL,
  texto TEXT NOT NULL,
  visivel_ao_denunciante TINYINT(1) NOT NULL DEFAULT 0,
  criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (denuncia_id) REFERENCES denuncias(id) ON DELETE CASCADE,
  FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS anexos (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  denuncia_id BIGINT NOT NULL,
  nome_original VARCHAR(255) NOT NULL,
  caminho VARCHAR(255) NOT NULL,
  mime VARCHAR(120) NULL,
  tamanho INT NULL,
  criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (denuncia_id) REFERENCES denuncias(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS logs_auditoria (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  usuario_id INT NULL,
  acao VARCHAR(80) NOT NULL,
  entidade VARCHAR(80) NOT NULL,
  entidade_id BIGINT NULL,
  detalhes JSON NULL,
  criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO usuarios(nome,email,cpf,senha_hash,perfil) VALUES(
  'Administrador','admin@empresa.com','00000000000',
  '$2y$10$4k2WnX5wq7v2vXr1o6bYbuJz3u3nQ8n4kKz7qI1tYqfZcC2y7Tq7O',
  'administrador'
) ON DUPLICATE KEY UPDATE email=email;
